package org.msh.tb.bd.tbforms.query.tb11;

import org.msh.tb.bd.Quarter;
import org.msh.tb.bd.tbforms.query.TbFormQuery;
import org.msh.tb.entities.AdministrativeUnit;
import org.msh.tb.entities.Tbunit;
import org.msh.tb.entities.Workspace;
import org.msh.tb.entities.enums.TbFormField;

import javax.persistence.EntityManager;
import javax.persistence.Query;
import java.util.List;

/**
 * Created by Mauricio on 17/03/2017.
 * Query database for Tb Form 11 Block 2 Result
 */
public class TBForm11Block2Query implements TbFormQuery {

    public static final TbFormField[] fields = new TbFormField[] {
            TbFormField.TB11_IPT_COLUMN1_MALE,
            TbFormField.TB11_IPT_COLUMN1_FEMALE,
            TbFormField.TB11_IPT_COLUMN2_MALE,
            TbFormField.TB11_IPT_COLUMN2_FEMALE,
            TbFormField.TB11_IPT_COLUMN3_MALE,
            TbFormField.TB11_IPT_COLUMN3_FEMALE
    };

    @Override
    public List<Object[]> queryDB(Tbunit tbunit, AdministrativeUnit adminUnit, Workspace workspace, Quarter selectedQuarter, EntityManager em) {
        Query query;

        //Start mounting query
        String queryStr = "select v.field, v.value " +
                "from TbFormValue v " +
                "where v.referenceDate between :iniDate and :endDate " +
                "and v.field in (" + getFieldIds() + ") ";

        if (tbunit != null) {
            // add tbunit restriction
            queryStr = queryStr + "and v.tbunit.id = :unitId";
            query = em.createQuery(queryStr);
            query.setParameter("unitId", tbunit.getId());
        } else if (adminUnit != null) {
            // add adminunit restriction
            queryStr = queryStr + "and v.tbunit.adminUnit.code like :code";
            query = em.createQuery(queryStr);
            query.setParameter("code", adminUnit.getCode() + "%");
        } else if (workspace != null) {
            // add workspace restriction
            queryStr = queryStr + "and v.tbunit.workspace.id = :wsId";
            query = em.createQuery(queryStr);
            query.setParameter("wsId", workspace.getId());
        } else {
            throw new RuntimeException("TbFormDbService: Tbunit, adminunit or workspace must be set.");
        }

        query.setParameter("iniDate", selectedQuarter.getIniDate());
        query.setParameter("endDate", selectedQuarter.getEndDate());

        return query.getResultList();
    }

    private String getFieldIds() {
        String ids = "";

        for (TbFormField field : fields) {
            ids = ids.concat(field.ordinal() + ",");
        }

        return ids.substring(0, ids.length()-1);
    }
}
